# Ćwiczenie 3

## Zadanie
Utwórz funkcję o nazwie `prefixer`, która pobiera parametr wejściowy typu string oraz zwraca funkcję pobierającą parametr wejściowy typu `string` i zwracającą wartość również typu `string`. Zwrócona funkcja powinna do jej danych wejściowych dodać prefiks przekazany przez funkcję `prefixer`. Gotową funkcję `prefixer` przetestuj za pomocą przedstawionej tutaj funkcji `main`.

```go
func main() {
    helloPrefix := prefixer("Hello")
    fmt.Println(helloPrefix("Bob")) // Powinien być wyświetlony komunikat "Hello Bob"
    fmt.Println(helloPrefix("Maria")) // Powinien być wyświetlony komunikat "Hello Maria"
}
```

## Rozwiązanie
Funkcja `prefixer` przedstawia się następująco:

```go
func prefixer(prefix string) func(string) string {
    return func (body string) string {
        return prefix + " " + body
    }
}
```
Zwracanym typem jest sygnatura funkcji, która posiada słowo kluczowe `func`, parametr danych wejściowych dla zwracanej funkcji (`(string)`) oraz typ zwracanej funkcji (`string`). W ciele funkcji zwracana jest funkcja anonimowa. Ta funkcja jest domknięciem; odwołuje się do parametru danych wejściowych `prefix` dla funkcji `prefixer`.